
/* DO NOT EDIT! This is an autogenerated file. See scripts/buildcommands.py. */

#include "board/irq.h"
#include "board/pgm.h"
#include "command.h"
#include "compiler.h"
#include "initial_pins.h"

void
ctr_run_initfuncs(void)
{
    extern void alloc_init(void);
    alloc_init();
    extern void initial_pins_setup(void);
    initial_pins_setup();
    extern void watchdog_init(void);
    watchdog_init();
    extern void timer_init(void);
    timer_init();
    extern void usbserial_init(void);
    usbserial_init();
    extern void chipid_init(void);
    chipid_init();
}

void
ctr_run_shutdownfuncs(void)
{
    extern void sendf_shutdown(void);
    sendf_shutdown();
    extern void move_reset(void);
    move_reset();
    extern void digital_out_shutdown(void);
    digital_out_shutdown();
    extern void stepper_shutdown(void);
    stepper_shutdown();
    extern void trsync_shutdown(void);
    trsync_shutdown();
    extern void analog_in_shutdown(void);
    analog_in_shutdown();
    extern void spidev_shutdown(void);
    spidev_shutdown();
    extern void pwm_shutdown(void);
    pwm_shutdown();
    extern void st7920_shutdown(void);
    st7920_shutdown();
    extern void hd44780_shutdown(void);
    hd44780_shutdown();
    extern void tmcuart_shutdown(void);
    tmcuart_shutdown();
    extern void clear_active_irq(void);
    clear_active_irq();
    extern void usb_shutdown(void);
    usb_shutdown();
}

void
ctr_run_taskfuncs(void)
{
    irq_poll();
    extern void trsync_task(void);
    trsync_task();
    irq_poll();
    extern void analog_in_task(void);
    analog_in_task();
    irq_poll();
    extern void thermocouple_task(void);
    thermocouple_task();
    irq_poll();
    extern void adxl345_task(void);
    adxl345_task();
    irq_poll();
    extern void spi_angle_task(void);
    spi_angle_task();
    irq_poll();
    extern void mpu9250_task(void);
    mpu9250_task();
    irq_poll();
    extern void buttons_task(void);
    buttons_task();
    irq_poll();
    extern void tmcuart_task(void);
    tmcuart_task();
    irq_poll();
    extern void counter_task(void);
    counter_task();
    irq_poll();
    extern void watchdog_reset(void);
    watchdog_reset();
    irq_poll();
    extern void timer_task(void);
    timer_task();
    irq_poll();
    extern void usb_errata_task(void);
    usb_errata_task();
    irq_poll();
    extern void usb_ep0_task(void);
    usb_ep0_task();
    irq_poll();
    extern void usb_bulk_out_task(void);
    usb_bulk_out_task();
    irq_poll();
    extern void usb_bulk_in_task(void);
    usb_bulk_in_task();
    irq_poll();
}

uint8_t __always_inline
ctr_lookup_static_string(const char *str)
{
    if (__builtin_strcmp(str, "Shutdown cleared when not shutdown") == 0)
        return 2;
    if (__builtin_strcmp(str, "Timer too close") == 0)
        return 3;
    if (__builtin_strcmp(str, "sentinel timer called") == 0)
        return 4;
    if (__builtin_strcmp(str, "Invalid command") == 0)
        return 5;
    if (__builtin_strcmp(str, "Message encode error") == 0)
        return 6;
    if (__builtin_strcmp(str, "Command parser error") == 0)
        return 7;
    if (__builtin_strcmp(str, "Command request") == 0)
        return 8;
    if (__builtin_strcmp(str, "config_reset only available when shutdown") == 0)
        return 9;
    if (__builtin_strcmp(str, "oids already allocated") == 0)
        return 10;
    if (__builtin_strcmp(str, "Can't assign oid") == 0)
        return 11;
    if (__builtin_strcmp(str, "Invalid oid type") == 0)
        return 12;
    if (__builtin_strcmp(str, "Already finalized") == 0)
        return 13;
    if (__builtin_strcmp(str, "Invalid move request size") == 0)
        return 14;
    if (__builtin_strcmp(str, "Move queue overflow") == 0)
        return 15;
    if (__builtin_strcmp(str, "alloc_chunks failed") == 0)
        return 16;
    if (__builtin_strcmp(str, "alloc_chunk failed") == 0)
        return 17;
    if (__builtin_strcmp(str, "update_digital_out not valid with active queue") == 0)
        return 18;
    if (__builtin_strcmp(str, "Scheduled digital out event will exceed max_duration") == 0)
        return 19;
    if (__builtin_strcmp(str, "Can not set soft pwm cycle ticks while updates pending") == 0)
        return 20;
    if (__builtin_strcmp(str, "Missed scheduling of next digital out event") == 0)
        return 21;
    if (__builtin_strcmp(str, "Can't reset time when stepper active") == 0)
        return 22;
    if (__builtin_strcmp(str, "Invalid count parameter") == 0)
        return 23;
    if (__builtin_strcmp(str, "Stepper too far in past") == 0)
        return 24;
    if (__builtin_strcmp(str, "Can't add signal that is already active") == 0)
        return 25;
    if (__builtin_strcmp(str, "ADC out of range") == 0)
        return 26;
    if (__builtin_strcmp(str, "Invalid spi config") == 0)
        return 27;
    if (__builtin_strcmp(str, "Thermocouple reader fault") == 0)
        return 28;
    if (__builtin_strcmp(str, "Thermocouple ADC out of range") == 0)
        return 29;
    if (__builtin_strcmp(str, "Invalid thermocouple chip type") == 0)
        return 30;
    if (__builtin_strcmp(str, "i2c_modify_bits: Odd number of bits!") == 0)
        return 31;
    if (__builtin_strcmp(str, "Scheduled pwm event will exceed max_duration") == 0)
        return 32;
    if (__builtin_strcmp(str, "Missed scheduling of next hard pwm event") == 0)
        return 33;
    if (__builtin_strcmp(str, "angle sensor requires cs pin") == 0)
        return 34;
    if (__builtin_strcmp(str, "Invalid spi_angle chip type") == 0)
        return 35;
    if (__builtin_strcmp(str, "Invalid buttons retransmit count") == 0)
        return 36;
    if (__builtin_strcmp(str, "Set button past maximum button count") == 0)
        return 37;
    if (__builtin_strcmp(str, "Max of 8 buttons") == 0)
        return 38;
    if (__builtin_strcmp(str, "tmcuart data too large") == 0)
        return 39;
    if (__builtin_strcmp(str, "Invalid neopixel update command") == 0)
        return 40;
    if (__builtin_strcmp(str, "Invalid neopixel data_size") == 0)
        return 41;
    if (__builtin_strcmp(str, "Not an input pin") == 0)
        return 42;
    if (__builtin_strcmp(str, "Not an output pin") == 0)
        return 43;
    if (__builtin_strcmp(str, "Not a valid ADC pin") == 0)
        return 44;
    if (__builtin_strcmp(str, "Rescheduled timer in the past") == 0)
        return 45;
    if (__builtin_strcmp(str, "Aliasing PWM pin already has PWM enabled") == 0)
        return 46;
    if (__builtin_strcmp(str, "PWM pin has different cycle time from another in the same slice") == 0)
        return 47;
    if (__builtin_strcmp(str, "invalid gpio pin") == 0)
        return 48;
    if (__builtin_strcmp(str, "Invalid spi bus") == 0)
        return 49;
    if (__builtin_strcmp(str, "i2c timeout") == 0)
        return 50;
    if (__builtin_strcmp(str, "Invalid i2c bus") == 0)
        return 51;
    return 0xff;
}

const struct initial_pin_s initial_pins[] PROGMEM = {
};
const int initial_pins_size PROGMEM = ARRAY_SIZE(initial_pins);

extern void DefaultHandler(void);
extern uint32_t _stack_end;
extern void TIMER0_IRQHandler(void);
extern void ResetHandler(void);
extern void USB_Handler(void);

const void *VectorTable[] __visible __section(".vector_table") = {
    &_stack_end,
    ResetHandler,
    DefaultHandler,
    DefaultHandler,
    DefaultHandler,
    DefaultHandler,
    DefaultHandler,
    DefaultHandler,
    DefaultHandler,
    DefaultHandler,
    DefaultHandler,
    DefaultHandler,
    DefaultHandler,
    DefaultHandler,
    DefaultHandler,
    DefaultHandler,
    TIMER0_IRQHandler,
    DefaultHandler,
    DefaultHandler,
    DefaultHandler,
    DefaultHandler,
    USB_Handler,
};

static const uint8_t command_parameters0[] PROGMEM = {
    PT_uint16 };
static const uint8_t command_parameters1[] PROGMEM = {
    PT_uint32, PT_uint16 };
static const uint8_t command_parameters2[] PROGMEM = {
    PT_uint32, PT_progmem_buffer };
static const uint8_t command_parameters3[] PROGMEM = {
    PT_uint32, PT_uint32, PT_uint32 };
static const uint8_t command_parameters4[] PROGMEM = {
    PT_uint32, PT_uint32 };
static const uint8_t command_parameters5[] PROGMEM = {
    PT_uint32 };
static const uint8_t command_parameters6[] PROGMEM = {
    PT_byte, PT_uint32, PT_byte, PT_uint16 };
static const uint8_t command_parameters7[] PROGMEM = {
    PT_buffer };
static const uint8_t command_parameters8[] PROGMEM = {
    PT_byte, PT_int32 };
static const uint8_t command_parameters9[] PROGMEM = {
    PT_byte, PT_byte, PT_uint32, PT_byte };
static const uint8_t command_parameters10[] PROGMEM = {
    PT_byte, PT_byte, PT_byte, PT_uint32 };
static const uint8_t command_parameters11[] PROGMEM = {
    PT_byte, PT_uint32, PT_uint16 };
static const uint8_t command_parameters12[] PROGMEM = {
    PT_byte, PT_buffer };
static const uint8_t command_parameters13[] PROGMEM = {
    PT_byte, PT_uint32, PT_uint32, PT_byte };
static const uint8_t command_parameters14[] PROGMEM = {
    PT_byte, PT_uint32, PT_uint32, PT_uint16, PT_byte, PT_byte, PT_uint16 };
static const uint8_t command_parameters15[] PROGMEM = {
    PT_byte, PT_uint16, PT_buffer };
static const uint8_t command_parameters16[] PROGMEM = {
    PT_byte, PT_uint32, PT_buffer };
static const uint8_t command_parameters17[] PROGMEM = {
    PT_byte, PT_uint16 };
static const uint8_t command_parameters18[] PROGMEM = {
    PT_byte, PT_uint32, PT_uint32, PT_uint16, PT_byte, PT_uint32, PT_uint16 };
static const uint8_t command_parameters19[] PROGMEM = {
    PT_byte, PT_byte, PT_buffer };
static const uint8_t command_parameters20[] PROGMEM = {
    PT_byte, PT_byte };
static const uint8_t command_parameters21[] PROGMEM = {
    PT_byte, PT_uint32, PT_uint32, PT_uint32 };
static const uint8_t command_parameters22[] PROGMEM = {
    PT_uint32, PT_byte };
static const uint8_t command_parameters23[] PROGMEM = {
    PT_byte };
static const uint8_t command_parameters24[] PROGMEM = {
    PT_byte, PT_uint32, PT_uint32 };
static const uint8_t command_parameters25[] PROGMEM = {
    PT_byte, PT_uint32 };
static const uint8_t command_parameters26[] PROGMEM = {
    PT_byte, PT_uint32, PT_byte };
static const uint8_t command_parameters27[] PROGMEM = {
    PT_byte, PT_uint32, PT_uint32, PT_byte, PT_uint32, PT_byte, PT_byte, PT_byte };
static const uint8_t command_parameters28[] PROGMEM = {
    PT_byte, PT_uint32, PT_uint32, PT_uint16, PT_uint16, PT_uint32 };
static const uint8_t command_parameters29[] PROGMEM = {
    PT_uint32, PT_uint32, PT_uint16 };
static const uint8_t command_parameters30[] PROGMEM = {
    PT_byte, PT_uint32, PT_uint16, PT_int16 };
static const uint8_t command_parameters31[] PROGMEM = {
    PT_byte, PT_uint32, PT_uint32, PT_byte, PT_byte };
static const uint8_t command_parameters32[] PROGMEM = {
    PT_byte, PT_byte, PT_byte };
static const uint8_t command_parameters33[] PROGMEM = {
    PT_byte, PT_uint32, PT_byte, PT_byte, PT_uint32 };
static const uint8_t command_parameters34[] PROGMEM = {
    PT_byte, PT_uint32, PT_uint32, PT_byte, PT_uint32, PT_uint16, PT_uint16, PT_byte };
static const uint8_t command_parameters35[] PROGMEM = {
    PT_byte, PT_buffer, PT_buffer };
static const uint8_t command_parameters36[] PROGMEM = {
    PT_byte, PT_uint32, PT_uint32, PT_uint32, PT_uint32, PT_uint32 };
static const uint8_t command_parameters37[] PROGMEM = {
    PT_byte, PT_buffer, PT_byte };
static const uint8_t command_parameters38[] PROGMEM = {
    PT_byte, PT_byte, PT_byte, PT_byte, PT_uint32 };
static const uint8_t command_parameters39[] PROGMEM = {
    PT_byte, PT_uint32, PT_uint32, PT_uint32, PT_uint32 };
static const uint8_t command_parameters40[] PROGMEM = {
    PT_byte, PT_uint32, PT_uint32, PT_uint32, PT_uint32, PT_uint32, PT_uint32, PT_uint32 };
static const uint8_t command_parameters41[] PROGMEM = {
    PT_byte, PT_uint32, PT_uint16, PT_uint32, PT_uint32 };
static const uint8_t command_parameters42[] PROGMEM = {
    PT_byte, PT_buffer, PT_uint32 };
static const uint8_t command_parameters43[] PROGMEM = {
    PT_byte, PT_uint32, PT_byte, PT_uint32, PT_uint32 };

const struct command_encoder command_encoder_76 PROGMEM = {    
    // starting
    .msg_id=76,
    .num_params=0,
    .param_types = 0,
    .max_size=6,
};
const struct command_encoder command_encoder_77 PROGMEM = {    
    // is_shutdown static_string_id=%hu
    .msg_id=77,
    .num_params=1,
    .param_types = command_parameters0,
    .max_size=9,
};
const struct command_encoder command_encoder_78 PROGMEM = {    
    // shutdown clock=%u static_string_id=%hu
    .msg_id=78,
    .num_params=2,
    .param_types = command_parameters1,
    .max_size=14,
};
const struct command_encoder command_encoder_0 PROGMEM = {    
    // identify_response offset=%u data=%.*s
    .msg_id=0,
    .num_params=2,
    .param_types = command_parameters2,
    .max_size=64,
};
const struct command_encoder command_encoder_79 PROGMEM = {    
    // stats count=%u sum=%u sumsq=%u
    .msg_id=79,
    .num_params=3,
    .param_types = command_parameters3,
    .max_size=21,
};
const struct command_encoder command_encoder_80 PROGMEM = {    
    // uptime high=%u clock=%u
    .msg_id=80,
    .num_params=2,
    .param_types = command_parameters4,
    .max_size=16,
};
const struct command_encoder command_encoder_81 PROGMEM = {    
    // clock clock=%u
    .msg_id=81,
    .num_params=1,
    .param_types = command_parameters5,
    .max_size=11,
};
const struct command_encoder command_encoder_82 PROGMEM = {    
    // config is_config=%c crc=%u is_shutdown=%c move_count=%hu
    .msg_id=82,
    .num_params=4,
    .param_types = command_parameters6,
    .max_size=18,
};
const struct command_encoder command_encoder_83 PROGMEM = {    
    // pong data=%*s
    .msg_id=83,
    .num_params=1,
    .param_types = command_parameters7,
    .max_size=64,
};
const struct command_encoder command_encoder_84 PROGMEM = {    
    // debug_result val=%u
    .msg_id=84,
    .num_params=1,
    .param_types = command_parameters5,
    .max_size=11,
};
const struct command_encoder command_encoder_85 PROGMEM = {    
    // stepper_position oid=%c pos=%i
    .msg_id=85,
    .num_params=2,
    .param_types = command_parameters8,
    .max_size=13,
};
const struct command_encoder command_encoder_86 PROGMEM = {    
    // endstop_state oid=%c homing=%c next_clock=%u pin_value=%c
    .msg_id=86,
    .num_params=4,
    .param_types = command_parameters9,
    .max_size=17,
};
const struct command_encoder command_encoder_87 PROGMEM = {    
    // trsync_state oid=%c can_trigger=%c trigger_reason=%c clock=%u
    .msg_id=87,
    .num_params=4,
    .param_types = command_parameters10,
    .max_size=17,
};
const struct command_encoder command_encoder_88 PROGMEM = {    
    // analog_in_state oid=%c next_clock=%u value=%hu
    .msg_id=88,
    .num_params=3,
    .param_types = command_parameters11,
    .max_size=16,
};
const struct command_encoder command_encoder_89 PROGMEM = {    
    // spi_transfer_response oid=%c response=%*s
    .msg_id=89,
    .num_params=2,
    .param_types = command_parameters12,
    .max_size=64,
};
const struct command_encoder command_encoder_90 PROGMEM = {    
    // thermocouple_result oid=%c next_clock=%u value=%u fault=%c
    .msg_id=90,
    .num_params=4,
    .param_types = command_parameters13,
    .max_size=20,
};
const struct command_encoder command_encoder_91 PROGMEM = {    
    // i2c_read_response oid=%c response=%*s
    .msg_id=91,
    .num_params=2,
    .param_types = command_parameters12,
    .max_size=64,
};
const struct command_encoder command_encoder_92 PROGMEM = {    
    // adxl345_status oid=%c clock=%u query_ticks=%u next_sequence=%hu buffered=%c fifo=%c limit_count=%hu
    .msg_id=92,
    .num_params=7,
    .param_types = command_parameters14,
    .max_size=28,
};
const struct command_encoder command_encoder_93 PROGMEM = {    
    // adxl345_data oid=%c sequence=%hu data=%*s
    .msg_id=93,
    .num_params=3,
    .param_types = command_parameters15,
    .max_size=64,
};
const struct command_encoder command_encoder_94 PROGMEM = {    
    // spi_angle_transfer_response oid=%c clock=%u response=%*s
    .msg_id=94,
    .num_params=3,
    .param_types = command_parameters16,
    .max_size=64,
};
const struct command_encoder command_encoder_95 PROGMEM = {    
    // spi_angle_end oid=%c sequence=%hu
    .msg_id=95,
    .num_params=2,
    .param_types = command_parameters17,
    .max_size=11,
};
const struct command_encoder command_encoder_96 PROGMEM = {    
    // spi_angle_data oid=%c sequence=%hu data=%*s
    .msg_id=96,
    .num_params=3,
    .param_types = command_parameters15,
    .max_size=64,
};
const struct command_encoder command_encoder_97 PROGMEM = {    
    // mpu9250_status oid=%c clock=%u query_ticks=%u next_sequence=%hu buffered=%c fifo=%u limit_count=%hu
    .msg_id=97,
    .num_params=7,
    .param_types = command_parameters18,
    .max_size=31,
};
const struct command_encoder command_encoder_98 PROGMEM = {    
    // mpu9250_data oid=%c sequence=%hu data=%*s
    .msg_id=98,
    .num_params=3,
    .param_types = command_parameters15,
    .max_size=64,
};
const struct command_encoder command_encoder_99 PROGMEM = {    
    // buttons_state oid=%c ack_count=%c state=%*s
    .msg_id=99,
    .num_params=3,
    .param_types = command_parameters19,
    .max_size=64,
};
const struct command_encoder command_encoder_100 PROGMEM = {    
    // tmcuart_response oid=%c read=%*s
    .msg_id=100,
    .num_params=2,
    .param_types = command_parameters12,
    .max_size=64,
};
const struct command_encoder command_encoder_101 PROGMEM = {    
    // neopixel_result oid=%c success=%c
    .msg_id=101,
    .num_params=2,
    .param_types = command_parameters20,
    .max_size=10,
};
const struct command_encoder command_encoder_102 PROGMEM = {    
    // counter_state oid=%c next_clock=%u count=%u count_clock=%u
    .msg_id=102,
    .num_params=4,
    .param_types = command_parameters21,
    .max_size=23,
};

const __always_inline struct command_encoder *
ctr_lookup_encoder(const char *str)
{
    if (__builtin_strcmp(str, "starting") == 0)
        return &command_encoder_76;
    if (__builtin_strcmp(str, "is_shutdown static_string_id=%hu") == 0)
        return &command_encoder_77;
    if (__builtin_strcmp(str, "shutdown clock=%u static_string_id=%hu") == 0)
        return &command_encoder_78;
    if (__builtin_strcmp(str, "identify_response offset=%u data=%.*s") == 0)
        return &command_encoder_0;
    if (__builtin_strcmp(str, "stats count=%u sum=%u sumsq=%u") == 0)
        return &command_encoder_79;
    if (__builtin_strcmp(str, "uptime high=%u clock=%u") == 0)
        return &command_encoder_80;
    if (__builtin_strcmp(str, "clock clock=%u") == 0)
        return &command_encoder_81;
    if (__builtin_strcmp(str, "config is_config=%c crc=%u is_shutdown=%c move_count=%hu") == 0)
        return &command_encoder_82;
    if (__builtin_strcmp(str, "pong data=%*s") == 0)
        return &command_encoder_83;
    if (__builtin_strcmp(str, "debug_result val=%u") == 0)
        return &command_encoder_84;
    if (__builtin_strcmp(str, "stepper_position oid=%c pos=%i") == 0)
        return &command_encoder_85;
    if (__builtin_strcmp(str, "endstop_state oid=%c homing=%c next_clock=%u pin_value=%c") == 0)
        return &command_encoder_86;
    if (__builtin_strcmp(str, "trsync_state oid=%c can_trigger=%c trigger_reason=%c clock=%u") == 0)
        return &command_encoder_87;
    if (__builtin_strcmp(str, "analog_in_state oid=%c next_clock=%u value=%hu") == 0)
        return &command_encoder_88;
    if (__builtin_strcmp(str, "spi_transfer_response oid=%c response=%*s") == 0)
        return &command_encoder_89;
    if (__builtin_strcmp(str, "thermocouple_result oid=%c next_clock=%u value=%u fault=%c") == 0)
        return &command_encoder_90;
    if (__builtin_strcmp(str, "i2c_read_response oid=%c response=%*s") == 0)
        return &command_encoder_91;
    if (__builtin_strcmp(str, "adxl345_status oid=%c clock=%u query_ticks=%u next_sequence=%hu buffered=%c fifo=%c limit_count=%hu") == 0)
        return &command_encoder_92;
    if (__builtin_strcmp(str, "adxl345_data oid=%c sequence=%hu data=%*s") == 0)
        return &command_encoder_93;
    if (__builtin_strcmp(str, "spi_angle_transfer_response oid=%c clock=%u response=%*s") == 0)
        return &command_encoder_94;
    if (__builtin_strcmp(str, "spi_angle_end oid=%c sequence=%hu") == 0)
        return &command_encoder_95;
    if (__builtin_strcmp(str, "spi_angle_data oid=%c sequence=%hu data=%*s") == 0)
        return &command_encoder_96;
    if (__builtin_strcmp(str, "mpu9250_status oid=%c clock=%u query_ticks=%u next_sequence=%hu buffered=%c fifo=%u limit_count=%hu") == 0)
        return &command_encoder_97;
    if (__builtin_strcmp(str, "mpu9250_data oid=%c sequence=%hu data=%*s") == 0)
        return &command_encoder_98;
    if (__builtin_strcmp(str, "buttons_state oid=%c ack_count=%c state=%*s") == 0)
        return &command_encoder_99;
    if (__builtin_strcmp(str, "tmcuart_response oid=%c read=%*s") == 0)
        return &command_encoder_100;
    if (__builtin_strcmp(str, "neopixel_result oid=%c success=%c") == 0)
        return &command_encoder_101;
    if (__builtin_strcmp(str, "counter_state oid=%c next_clock=%u count=%u count_clock=%u") == 0)
        return &command_encoder_102;
    return NULL;
}

const __always_inline struct command_encoder *
ctr_lookup_output(const char *str)
{
    
    return NULL;
}

extern void command_allocate_oids(uint32_t*);
extern void command_buttons_ack(uint32_t*);
extern void command_buttons_add(uint32_t*);
extern void command_buttons_query(uint32_t*);
extern void command_clear_shutdown(uint32_t*);
extern void command_config_adxl345(uint32_t*);
extern void command_config_analog_in(uint32_t*);
extern void command_config_buttons(uint32_t*);
extern void command_config_counter(uint32_t*);
extern void command_config_digital_out(uint32_t*);
extern void command_config_endstop(uint32_t*);
extern void command_config_hd44780(uint32_t*);
extern void command_config_i2c(uint32_t*);
extern void command_config_mpu9250(uint32_t*);
extern void command_config_neopixel(uint32_t*);
extern void command_config_pwm_out(uint32_t*);
extern void command_config_spi(uint32_t*);
extern void command_config_spi_angle(uint32_t*);
extern void command_config_spi_shutdown(uint32_t*);
extern void command_config_spi_without_cs(uint32_t*);
extern void command_config_st7920(uint32_t*);
extern void command_config_stepper(uint32_t*);
extern void command_config_thermocouple(uint32_t*);
extern void command_config_tmcuart(uint32_t*);
extern void command_config_trsync(uint32_t*);
extern void command_debug_nop(uint32_t*);
extern void command_debug_ping(uint32_t*);
extern void command_debug_read(uint32_t*);
extern void command_debug_write(uint32_t*);
extern void command_emergency_stop(uint32_t*);
extern void command_endstop_home(uint32_t*);
extern void command_endstop_query_state(uint32_t*);
extern void command_finalize_config(uint32_t*);
extern void command_get_clock(uint32_t*);
extern void command_get_config(uint32_t*);
extern void command_get_uptime(uint32_t*);
extern void command_hd44780_send_cmds(uint32_t*);
extern void command_hd44780_send_data(uint32_t*);
extern void command_i2c_modify_bits(uint32_t*);
extern void command_i2c_read(uint32_t*);
extern void command_i2c_write(uint32_t*);
extern void command_identify(uint32_t*);
extern void command_neopixel_send(uint32_t*);
extern void command_neopixel_update(uint32_t*);
extern void command_query_adxl345(uint32_t*);
extern void command_query_adxl345_status(uint32_t*);
extern void command_query_analog_in(uint32_t*);
extern void command_query_counter(uint32_t*);
extern void command_query_mpu9250(uint32_t*);
extern void command_query_mpu9250_status(uint32_t*);
extern void command_query_spi_angle(uint32_t*);
extern void command_query_thermocouple(uint32_t*);
extern void command_queue_digital_out(uint32_t*);
extern void command_queue_pwm_out(uint32_t*);
extern void command_queue_step(uint32_t*);
extern void command_reset(uint32_t*);
extern void command_reset_step_clock(uint32_t*);
extern void command_set_digital_out(uint32_t*);
extern void command_set_digital_out_pwm_cycle(uint32_t*);
extern void command_set_next_step_dir(uint32_t*);
extern void command_set_pwm_out(uint32_t*);
extern void command_spi_angle_transfer(uint32_t*);
extern void command_spi_send(uint32_t*);
extern void command_spi_set_bus(uint32_t*);
extern void command_spi_set_software_bus(uint32_t*);
extern void command_spi_transfer(uint32_t*);
extern void command_st7920_send_cmds(uint32_t*);
extern void command_st7920_send_data(uint32_t*);
extern void command_stepper_get_position(uint32_t*);
extern void command_stepper_stop_on_trigger(uint32_t*);
extern void command_tmcuart_send(uint32_t*);
extern void command_trsync_set_timeout(uint32_t*);
extern void command_trsync_start(uint32_t*);
extern void command_trsync_trigger(uint32_t*);
extern void command_update_digital_out(uint32_t*);

const struct command_parser command_index[] PROGMEM = {
{
}, {
    // identify offset=%u count=%c
    .msg_id=1,
    .num_params=2,
    .param_types = command_parameters22,
    .num_args=2,
    .flags=0x01,
    .func=command_identify
}, {
    // finalize_config crc=%u
    .msg_id=2,
    .num_params=1,
    .param_types = command_parameters5,
    .num_args=1,
    .flags=0,
    .func=command_finalize_config
}, {
    // config_trsync oid=%c
    .msg_id=3,
    .num_params=1,
    .param_types = command_parameters23,
    .num_args=1,
    .flags=0,
    .func=command_config_trsync
}, {
    // query_counter oid=%c clock=%u poll_ticks=%u sample_ticks=%u
    .msg_id=4,
    .num_params=4,
    .param_types = command_parameters21,
    .num_args=4,
    .flags=0,
    .func=command_query_counter
}, {
    // config_buttons oid=%c button_count=%c
    .msg_id=5,
    .num_params=2,
    .param_types = command_parameters20,
    .num_args=2,
    .flags=0,
    .func=command_config_buttons
}, {
    // clear_shutdown
    .msg_id=6,
    .num_params=0,
    .param_types = 0,
    .num_args=0,
    .flags=0x01,
    .func=command_clear_shutdown
}, {
    // set_digital_out pin=%u value=%c
    .msg_id=7,
    .num_params=2,
    .param_types = command_parameters22,
    .num_args=2,
    .flags=0,
    .func=command_set_digital_out
}, {
    // buttons_ack oid=%c count=%c
    .msg_id=8,
    .num_params=2,
    .param_types = command_parameters20,
    .num_args=2,
    .flags=0,
    .func=command_buttons_ack
}, {
    // endstop_query_state oid=%c
    .msg_id=9,
    .num_params=1,
    .param_types = command_parameters23,
    .num_args=1,
    .flags=0,
    .func=command_endstop_query_state
}, {
    // query_adxl345 oid=%c clock=%u rest_ticks=%u
    .msg_id=10,
    .num_params=3,
    .param_types = command_parameters24,
    .num_args=3,
    .flags=0,
    .func=command_query_adxl345
}, {
    // trsync_set_timeout oid=%c clock=%u
    .msg_id=11,
    .num_params=2,
    .param_types = command_parameters25,
    .num_args=2,
    .flags=0,
    .func=command_trsync_set_timeout
}, {
    // config_spi oid=%c pin=%u cs_active_high=%c
    .msg_id=12,
    .num_params=3,
    .param_types = command_parameters26,
    .num_args=3,
    .flags=0,
    .func=command_config_spi
}, {
    // get_uptime
    .msg_id=13,
    .num_params=0,
    .param_types = 0,
    .num_args=0,
    .flags=0x01,
    .func=command_get_uptime
}, {
    // endstop_home oid=%c clock=%u sample_ticks=%u sample_count=%c rest_ticks=%u pin_value=%c trsync_oid=%c trigger_reason=%c
    .msg_id=14,
    .num_params=8,
    .param_types = command_parameters27,
    .num_args=8,
    .flags=0,
    .func=command_endstop_home
}, {
    // config_pwm_out oid=%c pin=%u cycle_ticks=%u value=%hu default_value=%hu max_duration=%u
    .msg_id=15,
    .num_params=6,
    .param_types = command_parameters28,
    .num_args=6,
    .flags=0,
    .func=command_config_pwm_out
}, {
    // stepper_stop_on_trigger oid=%c trsync_oid=%c
    .msg_id=16,
    .num_params=2,
    .param_types = command_parameters20,
    .num_args=2,
    .flags=0,
    .func=command_stepper_stop_on_trigger
}, {
    // debug_ping data=%*s
    .msg_id=17,
    .num_params=1,
    .param_types = command_parameters7,
    .num_args=2,
    .flags=0x01,
    .func=command_debug_ping
}, {
    // set_pwm_out pin=%u cycle_ticks=%u value=%hu
    .msg_id=18,
    .num_params=3,
    .param_types = command_parameters29,
    .num_args=3,
    .flags=0,
    .func=command_set_pwm_out
}, {
    // queue_step oid=%c interval=%u count=%hu add=%hi
    .msg_id=19,
    .num_params=4,
    .param_types = command_parameters30,
    .num_args=4,
    .flags=0,
    .func=command_queue_step
}, {
    // allocate_oids count=%c
    .msg_id=20,
    .num_params=1,
    .param_types = command_parameters23,
    .num_args=1,
    .flags=0,
    .func=command_allocate_oids
}, {
    // buttons_query oid=%c clock=%u rest_ticks=%u retransmit_count=%c invert=%c
    .msg_id=21,
    .num_params=5,
    .param_types = command_parameters31,
    .num_args=5,
    .flags=0,
    .func=command_buttons_query
}, {
    // config_endstop oid=%c pin=%c pull_up=%c
    .msg_id=22,
    .num_params=3,
    .param_types = command_parameters32,
    .num_args=3,
    .flags=0,
    .func=command_config_endstop
}, {
    // config_spi_shutdown oid=%c spi_oid=%c shutdown_msg=%*s
    .msg_id=23,
    .num_params=3,
    .param_types = command_parameters19,
    .num_args=4,
    .flags=0,
    .func=command_config_spi_shutdown
}, {
    // config_digital_out oid=%c pin=%u value=%c default_value=%c max_duration=%u
    .msg_id=24,
    .num_params=5,
    .param_types = command_parameters33,
    .num_args=5,
    .flags=0,
    .func=command_config_digital_out
}, {
    // stepper_get_position oid=%c
    .msg_id=25,
    .num_params=1,
    .param_types = command_parameters23,
    .num_args=1,
    .flags=0,
    .func=command_stepper_get_position
}, {
    // st7920_send_data oid=%c data=%*s
    .msg_id=26,
    .num_params=2,
    .param_types = command_parameters12,
    .num_args=3,
    .flags=0,
    .func=command_st7920_send_data
}, {
    // query_analog_in oid=%c clock=%u sample_ticks=%u sample_count=%c rest_ticks=%u min_value=%hu max_value=%hu range_check_count=%c
    .msg_id=27,
    .num_params=8,
    .param_types = command_parameters34,
    .num_args=8,
    .flags=0,
    .func=command_query_analog_in
}, {
    // spi_angle_transfer oid=%c data=%*s
    .msg_id=28,
    .num_params=2,
    .param_types = command_parameters12,
    .num_args=3,
    .flags=0,
    .func=command_spi_angle_transfer
}, {
    // st7920_send_cmds oid=%c cmds=%*s
    .msg_id=29,
    .num_params=2,
    .param_types = command_parameters12,
    .num_args=3,
    .flags=0,
    .func=command_st7920_send_cmds
}, {
    // reset_step_clock oid=%c clock=%u
    .msg_id=30,
    .num_params=2,
    .param_types = command_parameters25,
    .num_args=2,
    .flags=0,
    .func=command_reset_step_clock
}, {
    // i2c_modify_bits oid=%c reg=%*s clear_set_bits=%*s
    .msg_id=31,
    .num_params=3,
    .param_types = command_parameters35,
    .num_args=5,
    .flags=0,
    .func=command_i2c_modify_bits
}, {
    // config_adxl345 oid=%c spi_oid=%c
    .msg_id=32,
    .num_params=2,
    .param_types = command_parameters20,
    .num_args=2,
    .flags=0,
    .func=command_config_adxl345
}, {
    // hd44780_send_data oid=%c data=%*s
    .msg_id=33,
    .num_params=2,
    .param_types = command_parameters12,
    .num_args=3,
    .flags=0,
    .func=command_hd44780_send_data
}, {
    // buttons_add oid=%c pos=%c pin=%u pull_up=%c
    .msg_id=34,
    .num_params=4,
    .param_types = command_parameters9,
    .num_args=4,
    .flags=0,
    .func=command_buttons_add
}, {
    // trsync_start oid=%c report_clock=%u report_ticks=%u expire_reason=%c
    .msg_id=35,
    .num_params=4,
    .param_types = command_parameters13,
    .num_args=4,
    .flags=0,
    .func=command_trsync_start
}, {
    // config_thermocouple oid=%c spi_oid=%c thermocouple_type=%c
    .msg_id=36,
    .num_params=3,
    .param_types = command_parameters32,
    .num_args=3,
    .flags=0,
    .func=command_config_thermocouple
}, {
    // spi_transfer oid=%c data=%*s
    .msg_id=37,
    .num_params=2,
    .param_types = command_parameters12,
    .num_args=3,
    .flags=0,
    .func=command_spi_transfer
}, {
    // i2c_write oid=%c data=%*s
    .msg_id=38,
    .num_params=2,
    .param_types = command_parameters12,
    .num_args=3,
    .flags=0,
    .func=command_i2c_write
}, {
    // reset
    .msg_id=39,
    .num_params=0,
    .param_types = 0,
    .num_args=0,
    .flags=0x01,
    .func=command_reset
}, {
    // config_st7920 oid=%c cs_pin=%u sclk_pin=%u sid_pin=%u sync_delay_ticks=%u cmd_delay_ticks=%u
    .msg_id=40,
    .num_params=6,
    .param_types = command_parameters36,
    .num_args=6,
    .flags=0,
    .func=command_config_st7920
}, {
    // emergency_stop
    .msg_id=41,
    .num_params=0,
    .param_types = 0,
    .num_args=0,
    .flags=0x01,
    .func=command_emergency_stop
}, {
    // neopixel_send oid=%c
    .msg_id=42,
    .num_params=1,
    .param_types = command_parameters23,
    .num_args=1,
    .flags=0,
    .func=command_neopixel_send
}, {
    // spi_set_bus oid=%c spi_bus=%u mode=%u rate=%u
    .msg_id=43,
    .num_params=4,
    .param_types = command_parameters21,
    .num_args=4,
    .flags=0,
    .func=command_spi_set_bus
}, {
    // config_counter oid=%c pin=%u pull_up=%c
    .msg_id=44,
    .num_params=3,
    .param_types = command_parameters26,
    .num_args=3,
    .flags=0,
    .func=command_config_counter
}, {
    // get_clock
    .msg_id=45,
    .num_params=0,
    .param_types = 0,
    .num_args=0,
    .flags=0x01,
    .func=command_get_clock
}, {
    // tmcuart_send oid=%c write=%*s read=%c
    .msg_id=46,
    .num_params=3,
    .param_types = command_parameters37,
    .num_args=4,
    .flags=0,
    .func=command_tmcuart_send
}, {
    // config_stepper oid=%c step_pin=%c dir_pin=%c invert_step=%c step_pulse_ticks=%u
    .msg_id=47,
    .num_params=5,
    .param_types = command_parameters38,
    .num_args=5,
    .flags=0,
    .func=command_config_stepper
}, {
    // query_spi_angle oid=%c clock=%u rest_ticks=%u time_shift=%c
    .msg_id=48,
    .num_params=4,
    .param_types = command_parameters13,
    .num_args=4,
    .flags=0,
    .func=command_query_spi_angle
}, {
    // set_digital_out_pwm_cycle oid=%c cycle_ticks=%u
    .msg_id=49,
    .num_params=2,
    .param_types = command_parameters25,
    .num_args=2,
    .flags=0,
    .func=command_set_digital_out_pwm_cycle
}, {
    // debug_write order=%c addr=%u val=%u
    .msg_id=50,
    .num_params=3,
    .param_types = command_parameters24,
    .num_args=3,
    .flags=0x01,
    .func=command_debug_write
}, {
    // queue_pwm_out oid=%c clock=%u value=%hu
    .msg_id=51,
    .num_params=3,
    .param_types = command_parameters11,
    .num_args=3,
    .flags=0,
    .func=command_queue_pwm_out
}, {
    // hd44780_send_cmds oid=%c cmds=%*s
    .msg_id=52,
    .num_params=2,
    .param_types = command_parameters12,
    .num_args=3,
    .flags=0,
    .func=command_hd44780_send_cmds
}, {
    // spi_set_software_bus oid=%c miso_pin=%u mosi_pin=%u sclk_pin=%u mode=%u rate=%u
    .msg_id=53,
    .num_params=6,
    .param_types = command_parameters36,
    .num_args=6,
    .flags=0,
    .func=command_spi_set_software_bus
}, {
    // config_mpu9250 oid=%c i2c_oid=%c
    .msg_id=54,
    .num_params=2,
    .param_types = command_parameters20,
    .num_args=2,
    .flags=0,
    .func=command_config_mpu9250
}, {
    // neopixel_update oid=%c pos=%hu data=%*s
    .msg_id=55,
    .num_params=3,
    .param_types = command_parameters15,
    .num_args=4,
    .flags=0,
    .func=command_neopixel_update
}, {
    // debug_read order=%c addr=%u
    .msg_id=56,
    .num_params=2,
    .param_types = command_parameters25,
    .num_args=2,
    .flags=0x01,
    .func=command_debug_read
}, {
    // query_thermocouple oid=%c clock=%u rest_ticks=%u min_value=%u max_value=%u
    .msg_id=57,
    .num_params=5,
    .param_types = command_parameters39,
    .num_args=5,
    .flags=0,
    .func=command_query_thermocouple
}, {
    // config_analog_in oid=%c pin=%u
    .msg_id=58,
    .num_params=2,
    .param_types = command_parameters25,
    .num_args=2,
    .flags=0,
    .func=command_config_analog_in
}, {
    // query_adxl345_status oid=%c
    .msg_id=59,
    .num_params=1,
    .param_types = command_parameters23,
    .num_args=1,
    .flags=0,
    .func=command_query_adxl345_status
}, {
    // config_spi_without_cs oid=%c
    .msg_id=60,
    .num_params=1,
    .param_types = command_parameters23,
    .num_args=1,
    .flags=0,
    .func=command_config_spi_without_cs
}, {
    // query_mpu9250 oid=%c clock=%u rest_ticks=%u
    .msg_id=61,
    .num_params=3,
    .param_types = command_parameters24,
    .num_args=3,
    .flags=0,
    .func=command_query_mpu9250
}, {
    // config_hd44780 oid=%c rs_pin=%u e_pin=%u d4_pin=%u d5_pin=%u d6_pin=%u d7_pin=%u delay_ticks=%u
    .msg_id=62,
    .num_params=8,
    .param_types = command_parameters40,
    .num_args=8,
    .flags=0,
    .func=command_config_hd44780
}, {
    // config_neopixel oid=%c pin=%u data_size=%hu bit_max_ticks=%u reset_min_ticks=%u
    .msg_id=63,
    .num_params=5,
    .param_types = command_parameters41,
    .num_args=5,
    .flags=0,
    .func=command_config_neopixel
}, {
    // spi_send oid=%c data=%*s
    .msg_id=64,
    .num_params=2,
    .param_types = command_parameters12,
    .num_args=3,
    .flags=0,
    .func=command_spi_send
}, {
    // config_spi_angle oid=%c spi_oid=%c spi_angle_type=%c
    .msg_id=65,
    .num_params=3,
    .param_types = command_parameters32,
    .num_args=3,
    .flags=0,
    .func=command_config_spi_angle
}, {
    // i2c_read oid=%c reg=%*s read_len=%u
    .msg_id=66,
    .num_params=3,
    .param_types = command_parameters42,
    .num_args=4,
    .flags=0,
    .func=command_i2c_read
}, {
    // trsync_trigger oid=%c reason=%c
    .msg_id=67,
    .num_params=2,
    .param_types = command_parameters20,
    .num_args=2,
    .flags=0,
    .func=command_trsync_trigger
}, {
    // query_mpu9250_status oid=%c
    .msg_id=68,
    .num_params=1,
    .param_types = command_parameters23,
    .num_args=1,
    .flags=0,
    .func=command_query_mpu9250_status
}, {
    // get_config
    .msg_id=69,
    .num_params=0,
    .param_types = 0,
    .num_args=0,
    .flags=0x01,
    .func=command_get_config
}, {
    // set_next_step_dir oid=%c dir=%c
    .msg_id=70,
    .num_params=2,
    .param_types = command_parameters20,
    .num_args=2,
    .flags=0,
    .func=command_set_next_step_dir
}, {
    // config_tmcuart oid=%c rx_pin=%u pull_up=%c tx_pin=%u bit_time=%u
    .msg_id=71,
    .num_params=5,
    .param_types = command_parameters43,
    .num_args=5,
    .flags=0,
    .func=command_config_tmcuart
}, {
    // update_digital_out oid=%c value=%c
    .msg_id=72,
    .num_params=2,
    .param_types = command_parameters20,
    .num_args=2,
    .flags=0,
    .func=command_update_digital_out
}, {
    // queue_digital_out oid=%c clock=%u on_ticks=%u
    .msg_id=73,
    .num_params=3,
    .param_types = command_parameters24,
    .num_args=3,
    .flags=0,
    .func=command_queue_digital_out
}, {
    // config_i2c oid=%c i2c_bus=%u rate=%u address=%u
    .msg_id=74,
    .num_params=4,
    .param_types = command_parameters21,
    .num_args=4,
    .flags=0,
    .func=command_config_i2c
}, {
    // debug_nop
    .msg_id=75,
    .num_params=0,
    .param_types = 0,
    .num_args=0,
    .flags=0x01,
    .func=command_debug_nop
},
};

const uint8_t command_index_size PROGMEM = ARRAY_SIZE(command_index);

// version: v0.10.0-530-g3387a9c2-dirty-20230310_140922-mkspi
// build_versions: gcc: (15:7-2018-q2-6) 7.3.1 20180622 (release) [ARM/embedded-7-branch revision 261907] binutils: (2.31.1-12+11) 2.31.1

const uint8_t command_identify_data[] PROGMEM = {
    0x78, 0xda, 0xa5, 0x19, 0x6b, 0x6f, 0xdb, 0xc8,
    0xf1, 0xaf, 0x6c, 0x05, 0x04, 0xbd, 0xb4, 0x96,
    0xcb, 0x87, 0x48, 0x49, 0x06, 0xf2, 0xc1, 0xf1,
    0xb9, 0xed, 0xa1, 0xf5, 0x25, 0x17, 0x3b, 0x68,
    0x81, 0xc3, 0x81, 0xa0, 0xc9, 0x95, 0xb4, 0x30,
    0x5f, 0xe1, 0x92, 0x7e, 0xf4, 0xe0, 0xff, 0xde,
    0x99, 0x9d, 0x7d, 0x91, 0x52, 0x72, 0x87, 0xd6,
    0x1f, 0xac, 0x7d, 0xcc, 0xce, 0xce, 0xce, 0x7b,
    0x86, 0xbf, 0x2e, 0xee, 0x47, 0x51, 0x95, 0xd9,
    0x23, 0xef, 0xa5, 0x68, 0x1b, 0xb9, 0xb8, 0x58,
    0xec, 0x8b, 0xe2, 0x82, 0x7d, 0x17, 0x26, 0x17,
    0xeb, 0x65, 0x14, 0x84, 0x9b, 0xe5, 0x97, 0x68,
    0x99, 0xbe, 0x65, 0xeb, 0xf3, 0xf8, 0x3c, 0x64,
    0xb8, 0x10, 0xa4, 0x51, 0xc4, 0xbe, 0xeb, 0x79,
    0xc5, 0x73, 0xc9, 0xdf, 0xb2, 0x9f, 0x2f, 0x3f,
    0xdd, 0xfc, 0x85, 0xd7, 0xf7, 0xbc, 0x2c, 0x79,
    0xb9, 0x5c, 0x2f, 0xef, 0xfb, 0xbc, 0x29, 0x0e,
    0xac, 0xe7, 0x8f, 0x02, 0x31, 0xb2, 0x28, 0x0d,
    0xb7, 0xc1, 0xfa, 0x17, 0x76, 0x2f, 0x9a, 0x71,
    0x10, 0x95, 0x04, 0xdc, 0xd1, 0x79, 0x1c, 0x9e,
    0x87, 0xcb, 0x30, 0xfa, 0x73, 0x18, 0xbe, 0x65,
    0x34, 0x5b, 0x9c, 0x2d, 0x8a, 0xb6, 0xae, 0xf3,
    0xa6, 0x04, 0x1a, 0x7e, 0x5d, 0xe4, 0x55, 0xd5,
    0x16, 0xf9, 0xc0, 0xb3, 0x56, 0x94, 0x92, 0x15,
    0xed, 0xd8, 0x0c, 0xef, 0xde, 0x14, 0x8b, 0x8b,
    0x28, 0x38, 0x03, 0x8a, 0x87, 0x01, 0x48, 0xcd,
    0xf2, 0xe2, 0x81, 0xc1, 0x36, 0xac, 0x7b, 0x00,
    0x1b, 0x6f, 0xbf, 0x2c, 0xcd, 0x7e, 0xd7, 0x4a,
    0xf5, 0x23, 0x9a, 0x77, 0x6f, 0x46, 0xd6, 0x8d,
    0x55, 0x95, 0x8d, 0x9d, 0x82, 0x8f, 0x57, 0xee,
    0xc0, 0x97, 0x91, 0xf7, 0x2f, 0x16, 0x25, 0x10,
    0xf0, 0x80, 0xd0, 0x3d, 0x97, 0x43, 0x36, 0x88,
    0xe2, 0x41, 0xd2, 0x6c, 0x80, 0x07, 0xca, 0x5a,
    0x0c, 0x99, 0xb9, 0x94, 0x89, 0x06, 0xd8, 0xa7,
    0xe9, 0x0b, 0xe1, 0x1d, 0xc0, 0x99, 0x3e, 0x93,
    0x87, 0x71, 0x28, 0xdb, 0xa7, 0x66, 0x71, 0x91,
    0xe2, 0xd3, 0x9a, 0x9d, 0xd8, 0x03, 0x45, 0xcf,
    0x55, 0xbc, 0x4a, 0xcc, 0x15, 0xb2, 0x13, 0x19,
    0x0d, 0x81, 0x8e, 0xc8, 0x41, 0x35, 0x79, 0xd5,
    0xee, 0x33, 0xd1, 0x58, 0xea, 0x15, 0xd9, 0x8b,
    0x8b, 0x64, 0x63, 0x61, 0x34, 0xc9, 0x06, 0x82,
    0xa6, 0x99, 0x63, 0x43, 0x62, 0x21, 0xd5, 0x1a,
    0xef, 0xa7, 0xb8, 0x26, 0x2c, 0x58, 0xad, 0x2c,
    0x70, 0x29, 0xf6, 0x62, 0xc8, 0xab, 0xac, 0x1d,
    0x87, 0xd9, 0x81, 0xc7, 0xbc, 0x1a, 0x39, 0xce,
    0x4b, 0xbe, 0xcb, 0xc7, 0x6a, 0xc8, 0xec, 0x42,
    0x9d, 0x3f, 0x67, 0xe5, 0xd8, 0xe7, 0x03, 0x48,
    0x5b, 0x91, 0x19, 0x39, 0x7c, 0x1c, 0xc4, 0x39,
    0xb4, 0xdd, 0x04, 0x57, 0x31, 0xb9, 0x3c, 0x72,
    0xef, 0x3e, 0x94, 0xab, 0xd5, 0x7a, 0x13, 0x18,
    0xe0, 0x5e, 0x66, 0xfa, 0x6e, 0x6e, 0x06, 0xe5,
    0xca, 0x8e, 0x12, 0x3b, 0x4a, 0xed, 0x68, 0x6d,
    0x47, 0xbc, 0xca, 0x5f, 0xac, 0xcc, 0x40, 0x02,
    0xee, 0x12, 0x11, 0x15, 0xe6, 0x02, 0x18, 0x02,
    0x1f, 0x49, 0xaa, 0xa0, 0x6a, 0xf8, 0x0b, 0x2a,
    0x03, 0xe2, 0xa6, 0x43, 0x6b, 0xf7, 0x8c, 0xba,
    0x1b, 0xb7, 0x51, 0x12, 0xf8, 0x07, 0x8d, 0xdc,
    0x12, 0x07, 0xd5, 0xf0, 0xb6, 0x13, 0xcf, 0xbc,
    0x9a, 0x71, 0xae, 0xcc, 0x87, 0x3c, 0x93, 0xe2,
    0x3f, 0x70, 0xc1, 0x61, 0x04, 0x33, 0x18, 0x32,
    0xe4, 0x98, 0xa7, 0x50, 0x92, 0xc3, 0x92, 0x68,
    0x7c, 0x7a, 0x63, 0x8b, 0xb4, 0x7b, 0xaa, 0x4f,
    0x48, 0xa3, 0x78, 0x01, 0x25, 0x73, 0x38, 0xb4,
    0x2c, 0x0e, 0xe3, 0x5c, 0x3a, 0xb0, 0x72, 0x24,
    0x9e, 0xd0, 0xe9, 0x06, 0x28, 0xe0, 0x1c, 0x31,
    0x9a, 0xd5, 0x20, 0x1e, 0x79, 0x76, 0x10, 0xfb,
    0x83, 0x7a, 0x61, 0x18, 0xf9, 0xf0, 0xa0, 0x9d,
    0xfb, 0x8a, 0x1f, 0x6b, 0x30, 0xb3, 0x7b, 0xd9,
    0xf0, 0xd2, 0x71, 0x75, 0x32, 0x9d, 0xdc, 0x64,
    0x2d, 0xe2, 0xd4, 0x61, 0xbd, 0x95, 0xd5, 0x72,
    0xff, 0xee, 0xcd, 0x9f, 0xc0, 0x05, 0x44, 0xf1,
    0xe4, 0xec, 0x93, 0x18, 0x0e, 0xc0, 0x86, 0xac,
    0x30, 0x2a, 0x0f, 0xd8, 0x03, 0x07, 0x31, 0xac,
    0xb7, 0x91, 0x15, 0x4f, 0x61, 0x15, 0x47, 0x16,
    0xd5, 0x83, 0x1d, 0x8b, 0xd2, 0x0e, 0x5f, 0x9a,
    0x22, 0x9b, 0xea, 0x08, 0x2b, 0xea, 0x32, 0x9b,
    0xab, 0xcd, 0xca, 0xbf, 0x81, 0x77, 0x9d, 0xb3,
    0x22, 0x9c, 0x66, 0x5a, 0x9b, 0x4b, 0xd1, 0x9b,
    0x21, 0x39, 0x02, 0x05, 0xec, 0xa0, 0xc6, 0x4a,
    0x72, 0x1f, 0xe9, 0xda, 0x22, 0x1d, 0x0e, 0xbc,
    0xaf, 0x5b, 0x30, 0xd0, 0xee, 0x24, 0x47, 0xfd,
    0x6d, 0xc7, 0xd4, 0xd8, 0xb9, 0x93, 0xa1, 0x2e,
    0xc6, 0xbc, 0xb7, 0xba, 0xd1, 0x3f, 0x67, 0x47,
    0xd6, 0xcd, 0x06, 0xbb, 0x88, 0x9a, 0x37, 0x88,
    0x9a, 0x93, 0x72, 0x87, 0x0e, 0x4b, 0x8f, 0xfc,
    0xb0, 0x6c, 0x05, 0xbe, 0x97, 0xfc, 0x7e, 0x04,
    0x75, 0x6e, 0x3b, 0x80, 0x4b, 0xcc, 0x14, 0xb0,
    0xec, 0x95, 0x2e, 0x93, 0x7c, 0xc2, 0xb5, 0xd9,
    0xe8, 0x79, 0x0e, 0x7e, 0xb6, 0x2f, 0x79, 0x8f,
    0xf7, 0xa1, 0x05, 0x91, 0xb3, 0x4a, 0x0d, 0xc0,
    0x53, 0x2f, 0x06, 0x7e, 0x04, 0x81, 0x4a, 0x4b,
    0x80, 0xc0, 0x65, 0x5e, 0xf3, 0x7e, 0xcf, 0x9b,
    0xe2, 0x25, 0x43, 0x77, 0x01, 0x4c, 0x02, 0xf2,
    0xb4, 0xef, 0xc8, 0x0e, 0x6d, 0xcd, 0x8f, 0x9c,
    0xb2, 0xcc, 0xeb, 0xce, 0xb7, 0x00, 0x3d, 0xb7,
    0x2e, 0x79, 0xea, 0xb4, 0x81, 0x76, 0xe7, 0xaf,
    0xe8, 0xbd, 0x96, 0xc9, 0xbd, 0xd8, 0xef, 0x79,
    0x8f, 0xaf, 0x90, 0x68, 0x20, 0xa8, 0xf0, 0x2b,
    0x77, 0xb9, 0x0a, 0x09, 0x40, 0x54, 0x3e, 0x70,
    0xcb, 0xa1, 0xed, 0xd9, 0x62, 0x27, 0xc0, 0x47,
    0x83, 0x49, 0x67, 0xc4, 0x43, 0x56, 0xf4, 0x05,
    0xb9, 0xbe, 0xb3, 0xc5, 0x1e, 0xac, 0x59, 0x91,
    0x09, 0xaf, 0x48, 0xf4, 0x54, 0x01, 0x81, 0xc6,
    0x6e, 0x69, 0x3e, 0x76, 0x28, 0x07, 0xb8, 0x08,
    0x78, 0xad, 0x9d, 0x5e, 0x26, 0xe1, 0xc6, 0x0c,
    0x94, 0xd0, 0xba, 0x74, 0x1c, 0x13, 0xab, 0x93,
    0x68, 0x06, 0x86, 0x52, 0x30, 0x60, 0x4e, 0x22,
    0x31, 0x60, 0x43, 0xcf, 0x54, 0xb7, 0xa5, 0xd8,
    0xbd, 0x64, 0x20, 0x6e, 0x8b, 0xab, 0xe7, 0xca,
    0xaa, 0x98, 0x8e, 0x4c, 0x40, 0x02, 0xee, 0xea,
    0x63, 0x21, 0x1d, 0x23, 0x31, 0x4e, 0xe1, 0x71,
    0x2d, 0xab, 0x38, 0xf9, 0x8d, 0x34, 0x25, 0x40,
    0x2d, 0xce, 0xa3, 0xeb, 0x21, 0x38, 0x89, 0x92,
    0x37, 0x03, 0x5c, 0xce, 0xda, 0xdd, 0x0e, 0x6e,
    0x51, 0x76, 0x65, 0x43, 0x12, 0xdc, 0x63, 0x3c,
    0xa4, 0x7a, 0x86, 0xe5, 0xe7, 0x2a, 0xf2, 0x76,
    0xc6, 0xae, 0x74, 0xbc, 0xa6, 0xb8, 0x7d, 0x18,
    0xbd, 0x6b, 0x12, 0xe0, 0x29, 0x09, 0x65, 0x16,
    0x4c, 0x4f, 0xc7, 0x6b, 0xb8, 0x36, 0x98, 0x1d,
    0x50, 0xd2, 0x1c, 0x9d, 0x1f, 0x49, 0xb6, 0x16,
    0x60, 0x1e, 0x78, 0xff, 0x47, 0x75, 0xab, 0x9d,
    0xba, 0x69, 0x07, 0xec, 0x66, 0x90, 0x3c, 0xec,
    0xe1, 0xe0, 0x81, 0x17, 0x0f, 0x5e, 0xb8, 0x8e,
    0xd6, 0x86, 0x86, 0x59, 0xb8, 0xb6, 0x14, 0x74,
    0x2d, 0x98, 0xf4, 0xfc, 0x7e, 0xcf, 0xab, 0x98,
    0xf3, 0xb3, 0x50, 0xf5, 0x35, 0xae, 0xa4, 0xe1,
    0xec, 0xc0, 0x9c, 0x2b, 0xe9, 0xc6, 0x00, 0x1c,
    0x39, 0xfd, 0xaf, 0x64, 0x46, 0xa8, 0xd3, 0xe0,
    0xe3, 0xc5, 0x8e, 0x9e, 0xb4, 0xb2, 0x08, 0x4e,
    0xb9, 0xb9, 0xaf, 0xe0, 0xf0, 0x38, 0x37, 0x61,
    0x1c, 0xba, 0x09, 0x62, 0xd1, 0xc8, 0x4f, 0x25,
    0x29, 0x16, 0x5d, 0xeb, 0x87, 0xd1, 0x75, 0x6c,
    0x8e, 0xcc, 0xa2, 0xa8, 0x05, 0xb7, 0x72, 0x01,
    0xfc, 0xa1, 0x01, 0x46, 0xb7, 0x6d, 0x43, 0x3d,
    0x0a, 0x83, 0x3c, 0x95, 0x51, 0xe5, 0x83, 0x4a,
    0x13, 0xe0, 0x57, 0x80, 0x72, 0x81, 0xee, 0xa8,
    0x00, 0x0e, 0xfa, 0x6f, 0x86, 0xea, 0x3c, 0xb9,
    0x80, 0xf9, 0x7d, 0x00, 0x05, 0xda, 0x88, 0x30,
    0xfe, 0x1b, 0x66, 0x19, 0x16, 0xd0, 0x7d, 0x04,
    0xa3, 0x1e, 0xa0, 0x82, 0xbe, 0x45, 0x39, 0xc9,
    0x00, 0x80, 0xdd, 0x5b, 0x3a, 0xd4, 0xf0, 0x67,
    0x4d, 0x01, 0xc4, 0x25, 0x6b, 0xa5, 0xa2, 0x27,
    0xc4, 0xfa, 0x76, 0xc3, 0x8e, 0xdf, 0xc8, 0x26,
    0xe0, 0x7d, 0x20, 0x44, 0x2f, 0xb0, 0x63, 0xe6,
    0xbb, 0x73, 0xca, 0xe9, 0xac, 0x32, 0xd2, 0x70,
    0x9e, 0x5d, 0x7b, 0xbb, 0xe9, 0xca, 0xec, 0x0e,
    0x98, 0x70, 0xf9, 0xa1, 0x4e, 0xe7, 0x5f, 0xe0,
    0xb3, 0xb8, 0x97, 0x87, 0xc1, 0x73, 0x62, 0x77,
    0x44, 0xb6, 0xbb, 0xe1, 0x29, 0xef, 0xb9, 0x7f,
    0xb6, 0x16, 0xb2, 0x35, 0x81, 0xad, 0x6e, 0xa5,
    0x38, 0x15, 0xf1, 0x8f, 0x90, 0x26, 0x1a, 0xe9,
    0xd7, 0xdf, 0x11, 0x23, 0xeb, 0x55, 0x32, 0xf1,
    0x2d, 0x87, 0x1c, 0x6d, 0xa7, 0x50, 0xa7, 0xfd,
    0x71, 0x94, 0x22, 0x94, 0x4a, 0x1b, 0x32, 0xf4,
    0xfa, 0xe0, 0xcb, 0x04, 0x26, 0x61, 0xd6, 0xc4,
    0xa2, 0xc4, 0x01, 0xa8, 0x60, 0x83, 0xca, 0x4b,
    0xe1, 0x88, 0xd9, 0xe8, 0xe4, 0xc5, 0x2a, 0x10,
    0x07, 0xa0, 0xd4, 0x41, 0x7f, 0xc2, 0x6a, 0xe5,
    0x92, 0xad, 0xc7, 0x26, 0xf3, 0x43, 0x50, 0x3a,
    0x8d, 0x3c, 0x44, 0xe3, 0x3c, 0x61, 0x00, 0x80,
    0x32, 0x74, 0x70, 0x83, 0x9f, 0x4c, 0xf0, 0xae,
    0xed, 0x75, 0x24, 0x23, 0x3b, 0x55, 0x73, 0xab,
    0x24, 0xfc, 0xb9, 0x13, 0x20, 0x12, 0x2f, 0x6c,
    0xc6, 0x89, 0xc5, 0x34, 0x7b, 0x85, 0x07, 0x94,
    0x02, 0x83, 0xc9, 0xc5, 0x9f, 0x32, 0x63, 0xcf,
    0x04, 0xa2, 0x57, 0x93, 0xa0, 0x60, 0x39, 0x78,
    0xf9, 0xfd, 0x55, 0x76, 0x73, 0xf9, 0x6f, 0x4c,
    0xc9, 0xb6, 0x70, 0xcd, 0xfb, 0xcf, 0xb7, 0xd9,
    0xc7, 0x1f, 0x7e, 0xbc, 0xc5, 0x6c, 0x3e, 0xc8,
    0xb1, 0x66, 0xed, 0x44, 0x1b, 0x9c, 0xe1, 0x7f,
    0x2c, 0x24, 0x27, 0xdb, 0xf7, 0x7a, 0x7b, 0xa5,
    0xb6, 0x93, 0xf9, 0x76, 0xa1, 0xb7, 0x37, 0x6a,
    0x7b, 0x3b, 0xdf, 0x2e, 0xf5, 0x36, 0x24, 0xc1,
    0xea, 0x27, 0x9e, 0x03, 0x70, 0x03, 0x90, 0x12,
    0xc0, 0x7a, 0x0e, 0xb0, 0xd3, 0x00, 0x11, 0xd1,
    0x17, 0x1d, 0x11, 0xb8, 0x37, 0x00, 0x44, 0x61,
    0x74, 0x44, 0xe2, 0xc1, 0x00, 0x10, 0x8d, 0xd1,
    0x9c, 0xc8, 0xd0, 0x70, 0x80, 0x68, 0x9c, 0x93,
    0x18, 0x1a, 0x0e, 0x10, 0x85, 0x73, 0x02, 0x43,
    0xc3, 0x81, 0x50, 0x33, 0x70, 0x4e, 0x60, 0x68,
    0x79, 0x40, 0x04, 0x86, 0x73, 0x02, 0x43, 0xcb,
    0x03, 0x22, 0x30, 0x3c, 0x22, 0xd0, 0xf2, 0x80,
    0x28, 0x8c, 0x8e, 0x48, 0xb4, 0x3c, 0x20, 0x1a,
    0xa3, 0x09, 0x91, 0x60, 0xb2, 0x33, 0x21, 0xc7,
    0x04, 0x35, 0x07, 0x9a, 0x8a, 0x7a, 0xad, 0xfe,
    0xa7, 0x73, 0xa0, 0x62, 0x26, 0xb0, 0x2d, 0xfd,
    0x6c, 0xe6, 0x70, 0xe5, 0x4c, 0x6e, 0xfa, 0xce,
    0xf9, 0xa5, 0x96, 0xf9, 0xfa, 0xed, 0x21, 0xfd,
    0x04, 0x73, 0xb0, 0xfb, 0x99, 0x22, 0x25, 0xf4,
    0xb3, 0x9a, 0xc3, 0x15, 0x33, 0x6d, 0xa0, 0x57,
    0x44, 0xf8, 0x8c, 0xab, 0x7f, 0x7e, 0xb8, 0xfa,
    0x47, 0xf6, 0xd7, 0x4f, 0xd7, 0x3f, 0x61, 0x51,
    0x16, 0xa8, 0xbf, 0xb3, 0xc5, 0xcd, 0xd5, 0x67,
    0x38, 0xd2, 0x77, 0x51, 0xb0, 0xc2, 0x4b, 0x3f,
    0xfe, 0xeb, 0x86, 0x2c, 0x25, 0xc2, 0x4c, 0xe9,
    0xf6, 0xee, 0xf2, 0xee, 0x36, 0xbb, 0xfd, 0x7c,
    0x73, 0xfb, 0x53, 0xf6, 0xfe, 0xf2, 0xf6, 0x1a,
    0x97, 0x53, 0x5c, 0xbe, 0xfe, 0xf8, 0xf1, 0xfa,
    0x53, 0xf6, 0xfe, 0xc3, 0xdd, 0xdf, 0xb3, 0xeb,
    0xef, 0xff, 0x06, 0xeb, 0xe1, 0x2b, 0x26, 0xbd,
    0x23, 0xe4, 0xe1, 0xaa, 0x52, 0x54, 0x4d, 0x18,
    0x5d, 0x20, 0xeb, 0x21, 0xca, 0x20, 0x50, 0x29,
    0x20, 0x32, 0x9a, 0xb2, 0x46, 0xe4, 0x66, 0x44,
    0xa3, 0x52, 0x95, 0x0e, 0xda, 0x24, 0x56, 0x34,
    0xda, 0xa9, 0x46, 0x84, 0x56, 0x72, 0x4a, 0x1f,
    0x51, 0x9b, 0xd7, 0x6a, 0x84, 0x9c, 0xdb, 0xd0,
    0xe8, 0x5e, 0x25, 0xd5, 0x5a, 0x19, 0x43, 0xba,
    0x04, 0xd5, 0x2e, 0xa4, 0x5b, 0x50, 0xc1, 0x42,
    0xba, 0x06, 0x55, 0x29, 0xa4, 0x7b, 0x50, 0x69,
    0xc2, 0x15, 0x90, 0x0d, 0xee, 0xde, 0xf8, 0x88,
    0xbb, 0xeb, 0x1b, 0x78, 0xd7, 0xe5, 0xdd, 0xe7,
    0x4f, 0xea, 0xa9, 0x40, 0x86, 0x52, 0x9a, 0xc5,
    0xc5, 0xcf, 0xc1, 0x59, 0x1c, 0xfc, 0xf2, 0x3a,
    0x89, 0x66, 0x50, 0x51, 0xa9, 0x56, 0x53, 0x18,
    0xc7, 0xb1, 0x7a, 0x5a, 0x2e, 0x93, 0x60, 0xb5,
    0x2e, 0xd5, 0xe3, 0x86, 0x8a, 0x27, 0x41, 0x18,
    0x01, 0x65, 0x91, 0x3e, 0xa5, 0x39, 0xa1, 0xb5,
    0x31, 0x50, 0x8b, 0x9a, 0x13, 0x5a, 0xaf, 0x22,
    0x1a, 0x11, 0x27, 0xb4, 0x6e, 0x50, 0xe8, 0xc3,
    0x17, 0x26, 0x34, 0x42, 0x27, 0x88, 0x18, 0x21,
    0xdd, 0x12, 0xe8, 0x73, 0x7b, 0xa8, 0xab, 0x32,
    0x51, 0xea, 0x17, 0x30, 0xe5, 0x0d, 0x77, 0x94,
    0x26, 0x52, 0x0c, 0xb9, 0xac, 0x44, 0x2e, 0xb1,
    0xf8, 0x02, 0xd1, 0x62, 0xc4, 0x66, 0x79, 0x85,
    0x5e, 0xfe, 0x85, 0x1d, 0x72, 0xa9, 0xd6, 0x78,
    0x93, 0xdf, 0x57, 0xbc, 0x24, 0x9f, 0x7f, 0xa9,
    0x37, 0x4d, 0x85, 0x52, 0x12, 0xbf, 0xae, 0xf2,
    0x86, 0x35, 0xed, 0xc0, 0x20, 0x16, 0x30, 0x8c,
    0xa7, 0x0c, 0x52, 0x00, 0x8a, 0xfb, 0x4c, 0xb9,
    0x74, 0xf6, 0x74, 0x10, 0x30, 0x26, 0xd7, 0x2c,
    0x59, 0x07, 0xc1, 0x05, 0xae, 0xa4, 0x7e, 0x1b,
    0x9c, 0xfd, 0xe3, 0x80, 0x39, 0x0f, 0xd4, 0xd0,
    0x7b, 0xc0, 0x0a, 0x85, 0x69, 0x3e, 0x30, 0x21,
    0x2d, 0x21, 0xd4, 0x31, 0xa0, 0x80, 0xa6, 0x81,
    0x25, 0x82, 0xa2, 0x5b, 0x27, 0x21, 0xd2, 0xaa,
    0x4a, 0x8f, 0x54, 0x9e, 0x08, 0xd7, 0xf1, 0x86,
    0x99, 0xa2, 0xda, 0x9e, 0x07, 0x06, 0x5e, 0x51,
    0x13, 0x90, 0x75, 0x79, 0x2f, 0x61, 0x8b, 0xf7,
    0x7d, 0xdb, 0x2b, 0x8d, 0x31, 0x1b, 0x3d, 0x87,
    0x2c, 0x4d, 0x0e, 0x4a, 0x77, 0x7e, 0x68, 0x20,
    0x62, 0x88, 0x92, 0x99, 0x6e, 0x98, 0x6b, 0xce,
    0x51, 0xb2, 0x46, 0xd5, 0xb2, 0x81, 0xd2, 0xfd,
    0x45, 0x25, 0x09, 0xb7, 0x06, 0x60, 0x78, 0x59,
    0x5e, 0x73, 0xc8, 0xf4, 0xa8, 0xef, 0x60, 0x36,
    0xb1, 0x57, 0xa4, 0xa4, 0x8e, 0xb9, 0xa1, 0x59,
    0xac, 0xdb, 0x47, 0x6e, 0x88, 0x60, 0xd8, 0xd6,
    0xa1, 0x82, 0xd1, 0x6c, 0xdb, 0x26, 0x90, 0x6d,
    0xfb, 0x50, 0x35, 0x7b, 0xb4, 0xaf, 0x0b, 0x1d,
    0x4b, 0x14, 0x36, 0x1b, 0x0c, 0x10, 0xf0, 0x8d,
    0x91, 0x7a, 0xa2, 0xda, 0x9b, 0x55, 0xec, 0xd6,
    0x28, 0x72, 0x30, 0xd7, 0xf3, 0x17, 0x4d, 0x9c,
    0xc4, 0x2a, 0xc2, 0x5b, 0xd7, 0x59, 0x7b, 0x71,
    0x10, 0x9d, 0xc6, 0x16, 0x7b, 0x2f, 0x9f, 0x64,
    0xe5, 0x3e, 0x0c, 0xfa, 0x94, 0xfc, 0x19, 0x95,
    0x70, 0x63, 0x18, 0x4b, 0xd5, 0xdd, 0x0d, 0x97,
    0x32, 0xdf, 0x73, 0xd0, 0xb7, 0x02, 0x32, 0x2b,
    0x23, 0x1a, 0x60, 0xf0, 0x8d, 0x90, 0x92, 0xc3,
    0x95, 0x50, 0xd5, 0x94, 0x63, 0x85, 0xaa, 0x0a,
    0x87, 0x31, 0x11, 0x65, 0x3a, 0xc6, 0x2b, 0xad,
    0xe6, 0x8f, 0x1c, 0x25, 0x82, 0x1d, 0xd2, 0xaf,
    0x1f, 0x38, 0xe4, 0x7d, 0xa9, 0x74, 0x53, 0x43,
    0x63, 0x51, 0x7b, 0x83, 0x1c, 0x57, 0xa9, 0x39,
    0x83, 0x51, 0xbf, 0xab, 0xda, 0x27, 0xea, 0x62,
    0xfd, 0x08, 0x0a, 0x9d, 0x33, 0x7a, 0x0e, 0xda,
    0x8e, 0x72, 0x04, 0xd8, 0xcd, 0x54, 0x1b, 0x0d,
    0x24, 0xef, 0x1d, 0x25, 0xb9, 0x54, 0x63, 0xea,
    0x55, 0xa0, 0xc5, 0x2d, 0xc7, 0xca, 0x63, 0x2a,
    0xb3, 0x42, 0x73, 0x82, 0xca, 0x19, 0xf2, 0x42,
    0xb8, 0xd9, 0xda, 0x06, 0xe8, 0xea, 0xae, 0x6f,
    0x6b, 0x38, 0xd8, 0x22, 0xc7, 0x00, 0x27, 0x72,
    0x0e, 0x0b, 0x30, 0xf8, 0x57, 0x89, 0x82, 0x53,
    0x47, 0xe7, 0x13, 0xd7, 0x8f, 0x81, 0x67, 0xe1,
    0x21, 0x0b, 0xd8, 0xe5, 0xa8, 0xab, 0xd8, 0x09,
    0xb8, 0xb5, 0x00, 0x47, 0x5c, 0x61, 0x4f, 0xa2,
    0xaa, 0x20, 0xa5, 0x2a, 0x38, 0xec, 0xfa, 0x0d,
    0x3b, 0xaa, 0x30, 0xdc, 0x49, 0xcb, 0x99, 0x6f,
    0x9c, 0xc0, 0x4e, 0xf2, 0x2d, 0xd8, 0x19, 0xc9,
    0x4e, 0x11, 0x80, 0x10, 0xa2, 0x1e, 0x6b, 0xb3,
    0x66, 0x8c, 0x03, 0x08, 0xbf, 0x35, 0x4d, 0x39,
    0xd5, 0x1b, 0x00, 0x64, 0xca, 0x32, 0x95, 0xab,
    0xb0, 0x0d, 0x6c, 0x44, 0xa8, 0x4d, 0x75, 0x68,
    0x5b, 0xb6, 0xcb, 0xd5, 0xeb, 0xe8, 0x65, 0xd8,
    0xec, 0xbd, 0xf3, 0x55, 0xe9, 0x84, 0x13, 0xdb,
    0xce, 0x40, 0xd0, 0x6b, 0x00, 0x2e, 0xd5, 0xa9,
    0xa4, 0xda, 0xe1, 0x4e, 0xb1, 0x0c, 0x91, 0x43,
    0xc2, 0x29, 0xb9, 0x72, 0xa0, 0xea, 0x13, 0x00,
    0x54, 0xca, 0x63, 0xf3, 0x00, 0xa0, 0x42, 0x79,
    0x38, 0xec, 0x3a, 0x79, 0xeb, 0xd2, 0x6d, 0x80,
    0x1a, 0x92, 0xba, 0x43, 0x5e, 0x2c, 0xdb, 0x5e,
    0x59, 0x28, 0x24, 0xa8, 0x92, 0x15, 0x92, 0x44,
    0x1d, 0xbb, 0x46, 0x2d, 0xf9, 0xa1, 0xb6, 0xa9,
    0xc0, 0x75, 0x3d, 0x02, 0x02, 0x74, 0x9f, 0xda,
    0x23, 0xd9, 0x37, 0x53, 0x3c, 0x62, 0x3a, 0x6f,
    0xa6, 0x2e, 0xd5, 0xac, 0xbb, 0x72, 0xc1, 0x3e,
    0x80, 0x4f, 0x84, 0x98, 0x79, 0x8f, 0xa9, 0xee,
    0x0e, 0x1b, 0x6c, 0xf2, 0x0f, 0xba, 0xa1, 0xa2,
    0x8d, 0x0c, 0xa3, 0x8f, 0xd6, 0x34, 0x78, 0xa5,
    0xfa, 0x96, 0x61, 0x9d, 0xa6, 0xfe, 0xc2, 0x51,
    0x52, 0xc4, 0x93, 0xd8, 0x39, 0x69, 0xc0, 0x2f,
    0x90, 0xf6, 0x14, 0xb0, 0xad, 0x5c, 0xba, 0x4d,
    0xf8, 0x95, 0x43, 0x51, 0x2c, 0xaa, 0xf2, 0x1e,
    0xd9, 0x8a, 0x05, 0xe7, 0x89, 0x54, 0x1a, 0x45,
    0x47, 0x97, 0x63, 0xcf, 0x54, 0xfb, 0x56, 0x32,
    0x1f, 0xac, 0xe7, 0x20, 0xf4, 0x1c, 0xf5, 0x15,
    0x31, 0xf6, 0x40, 0xce, 0x10, 0x87, 0x9b, 0x24,
    0x51, 0x91, 0x4d, 0x4f, 0x52, 0x15, 0xdc, 0x68,
    0x92, 0x26, 0x4a, 0x0f, 0x60, 0x92, 0xa6, 0x6b,
    0x18, 0xc7, 0xaf, 0xaf, 0xaa, 0xde, 0xed, 0xc0,
    0x3d, 0x70, 0xfa, 0x64, 0xa3, 0xdb, 0x2b, 0x7e,
    0x35, 0x24, 0xd1, 0x4f, 0x36, 0x05, 0x9f, 0x35,
    0x71, 0xb6, 0x28, 0xde, 0x53, 0xdd, 0x18, 0x57,
    0x99, 0xeb, 0xd6, 0x81, 0x29, 0x37, 0xa8, 0xac,
    0xf5, 0xb1, 0xdd, 0x8f, 0xca, 0x54, 0xd5, 0xa9,
    0x9d, 0xd8, 0xb5, 0xf8, 0x5b, 0x09, 0xef, 0xbb,
    0x0c, 0xd6, 0xaf, 0xdb, 0x08, 0xd5, 0x42, 0x77,
    0x75, 0x26, 0x6d, 0x3c, 0xc2, 0x78, 0xaa, 0x11,
    0xb0, 0xf1, 0x3e, 0x21, 0x4d, 0x4e, 0xe4, 0x5e,
    0xcb, 0x86, 0xa9, 0x1d, 0x7a, 0xcd, 0x12, 0x15,
    0x9c, 0xea, 0x7d, 0x57, 0x57, 0x6d, 0x6c, 0x83,
    0x15, 0x22, 0xa5, 0xee, 0x00, 0xaa, 0x07, 0xaa,
    0x4e, 0x21, 0xae, 0x19, 0x5d, 0x53, 0xe5, 0x2c,
    0x38, 0x36, 0x9f, 0xee, 0x8d, 0xea, 0xb9, 0xab,
    0x4e, 0xd0, 0xb7, 0xa8, 0xd6, 0x27, 0xf4, 0x20,
    0x73, 0xb7, 0x2f, 0xa3, 0xd4, 0xb5, 0x67, 0x25,
    0x98, 0x99, 0xed, 0xb6, 0x6e, 0xbc, 0xe6, 0xe6,
    0x04, 0xf3, 0xa1, 0xad, 0xc1, 0x11, 0x1f, 0xdf,
    0xe1, 0xf7, 0x4e, 0xe1, 0x78, 0xea, 0xba, 0x85,
    0x99, 0x11, 0xbf, 0xab, 0xf3, 0x68, 0xae, 0x85,
    0x1c, 0xba, 0x86, 0xa0, 0x07, 0x6a, 0x3b, 0x83,
    0xa4, 0x0e, 0xe7, 0x08, 0x8a, 0xb6, 0xe5, 0x18,
    0xc2, 0xe6, 0xb9, 0x11, 0xf1, 0x64, 0x0d, 0xb6,
    0x6f, 0x9a, 0x55, 0xbf, 0x43, 0xc7, 0x96, 0x18,
    0xc8, 0x4e, 0x36, 0xb7, 0xfe, 0x2f, 0x25, 0x1b,
    0x8f, 0x95, 0x6c, 0x19, 0xfb, 0xad, 0x4d, 0xcd,
    0x6f, 0x43, 0xdc, 0x58, 0x14, 0xea, 0x83, 0x52,
    0x81, 0x42, 0x81, 0x17, 0x00, 0x17, 0xfc, 0x36,
    0xfa, 0x06, 0x33, 0x45, 0xe7, 0x82, 0x4d, 0xbb,
    0xf1, 0x34, 0x03, 0x26, 0xcd, 0x98, 0xdf, 0xc5,
    0x82, 0xc8, 0x3f, 0xe1, 0x35, 0x0c, 0xfc, 0x03,
    0x20, 0xa9, 0xe4, 0x54, 0x97, 0xe7, 0x48, 0xbc,
    0x7e, 0xcf, 0xce, 0x97, 0xf3, 0x6a, 0xda, 0x55,
    0xf9, 0x0d, 0xb5, 0xd8, 0xa8, 0xe6, 0x09, 0x38,
    0x34, 0x95, 0x5f, 0xae, 0x53, 0x4a, 0x85, 0xa5,
    0xd3, 0x65, 0x39, 0xd6, 0xfa, 0x47, 0x7e, 0xa1,
    0x36, 0xde, 0xd6, 0xf5, 0x49, 0x66, 0x4d, 0x14,
    0x6a, 0x10, 0x0b, 0xc0, 0x9a, 0xcc, 0xfc, 0xda,
    0x54, 0x0c, 0x27, 0x8d, 0x7d, 0xa4, 0x08, 0x44,
    0x3d, 0xfd, 0xc0, 0x75, 0x56, 0x8e, 0xe9, 0xc7,
    0x9e, 0x0a, 0x59, 0xfa, 0xc6, 0xef, 0x96, 0x38,
    0xe3, 0x29, 0x72, 0xdb, 0xba, 0x39, 0xf9, 0x51,
    0xc1, 0x77, 0x0c, 0xaa, 0x03, 0xa2, 0x12, 0x0b,
    0xfa, 0xc4, 0x36, 0xfa, 0x9b, 0x01, 0x78, 0x55,
    0xfd, 0x2d, 0x1e, 0xaa, 0xba, 0xc7, 0xe0, 0x3c,
    0x0c, 0xce, 0x83, 0x65, 0x12, 0x07, 0xcb, 0x7d,
    0x1c, 0x6f, 0xd6, 0xf9, 0xb6, 0x88, 0x96, 0xa5,
    0xe8, 0x87, 0x97, 0x65, 0x14, 0x44, 0x71, 0x10,
    0x87, 0x41, 0x16, 0xae, 0x82, 0x6d, 0x14, 0x2d,
    0xeb, 0x07, 0x10, 0xc2, 0xe2, 0xf5, 0xbf, 0xed,
    0x2c, 0x8a, 0x8c,
};

// Identify size = 2867 (8145 uncompressed)
const uint32_t command_identify_size PROGMEM
    = ARRAY_SIZE(command_identify_data);
